/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.client.model.CannonModel;
import com.talhanation.smallships.client.model.ShipModel;
import com.talhanation.smallships.client.model.sail.BriggSailModel;
import com.talhanation.smallships.client.model.sail.CogSailModel;
import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.BriggEntity;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import com.talhanation.smallships.world.entity.ship.KhufuEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1088;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2499;
import net.minecraft.class_2573;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_823;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public abstract class ShipRenderer<T extends Ship>
extends class_897<T> {
    protected final Map<class_1690.class_1692, Pair<class_2960, ShipModel<T>>> boatResources;
    private static final class_630 bannerModel;
    private static final Map<Class<? extends Ship>, SailModel> sailModels;

    public ShipRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(class_1690.class_1692.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)this.getTextureLocation((class_1690.class_1692)type), this.createBoatModel(context, (class_1690.class_1692)type))));
    }

    protected abstract ShipModel<T> createBoatModel(class_5617.class_5618 var1, class_1690.class_1692 var2);

    protected abstract class_2960 getTextureLocation(class_1690.class_1692 var1);

    public class_2960 getTextureLocation(@NotNull T shipEntity) {
        return (class_2960)this.boatResources.get(shipEntity.method_7536()).getFirst();
    }

    public void render(T shipEntity, float entityYaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        float l;
        float k;
        Attributes shipAttributes = ((Ship)((Object)shipEntity)).getAttributes();
        float h = ((float)shipEntity.method_7533() - partialTicks) / (shipAttributes.maxHealth * shipEntity.method_17681() / 40.0f);
        float j = shipEntity.method_7554() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        } else if (j > shipAttributes.maxHealth * 0.5f) {
            ((Ship)((Object)shipEntity)).field_6002.method_8406((class_2394)class_2398.field_11237, shipEntity.method_23322(0.5), shipEntity.method_23318() + 1.0, shipEntity.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        if (h > 0.0f) {
            poseStack.method_22907(class_1160.field_20703.method_23214(class_3532.method_15374((float)h) * h * j / 10.0f * (float)shipEntity.method_7543()));
        }
        if (!class_3532.method_15347((float)(k = shipEntity.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new class_1158(new class_1160(1.0f, 0.0f, 1.0f), k, true));
        }
        if (!class_3532.method_15347((float)(l = ((Ship)((Object)shipEntity)).getWaveAngle(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(class_1160.field_20707.method_23214(l));
        }
        Pair<class_2960, ShipModel<T>> pair = this.boatResources.get(shipEntity.method_7536());
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        ShipModel shipModel = (ShipModel)((Object)pair.getSecond());
        poseStack.method_22905(-1.3f, -1.3f, 1.3f);
        poseStack.method_22907(class_1160.field_20705.method_23214(270.0f));
        shipModel.method_2819((class_1297)shipEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (shipEntity instanceof Cannonable) {
            Cannonable cannonShipEntity = (Cannonable)shipEntity;
            this.renderCannon(cannonShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Bannerable) {
            Bannerable bannerShipEntity = (Bannerable)shipEntity;
            this.renderBanner(bannerShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Paddleable) {
            Paddleable paddleShipEntity = (Paddleable)shipEntity;
            this.renderPaddle(paddleShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Sailable) {
            Sailable sailShipEntity = (Sailable)shipEntity;
            this.renderSail(sailShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(shipModel.method_23500(resourceLocation));
        shipModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
        super.method_3936(shipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    private void renderCannon(Cannonable cannonShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        double offsetX;
        int i;
        Cannonable.CannonPosition cannonPosition = cannonShipEntity.getCannonPosition();
        Consumer<Pair> renderCannon = args -> {
            poseStack.method_22903();
            poseStack.method_22907(class_1160.field_20705.method_23214(cannonPosition.angle + ((Float)args.getSecond()).floatValue()));
            poseStack.method_22904(((Double)args.getFirst()).doubleValue(), cannonPosition.offsetY, cannonPosition.offsetZ);
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
            CannonModel cannonModel = new CannonModel();
            cannonModel.setupAnim((Ship)((Object)((Object)cannonShipEntity)), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            class_4588 vertexConsumer = multiBufferSource.getBuffer(cannonModel.method_23500(cannonShipEntity.getTextureLocation()));
            cannonModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        };
        for (i = 0; i < cannonShipEntity.getCannonCountRight(); ++i) {
            offsetX = switch (i) {
                case 0 -> -1.0;
                case 1 -> 0.2;
                case 2 -> 1.5;
                default -> 0.0;
            };
            renderCannon.accept(new Pair((Object)offsetX, (Object)Float.valueOf(180.0f)));
        }
        for (i = 0; i < cannonShipEntity.getCannonCountLeft(); ++i) {
            offsetX = switch (i) {
                case 0 -> 1.0;
                case 1 -> -0.2;
                case 2 -> -1.5;
                default -> 0.0;
            };
            renderCannon.accept(new Pair((Object)offsetX, (Object)Float.valueOf(0.0f)));
        }
    }

    private void renderBanner(Bannerable bannerShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        class_1799 item = bannerShipEntity.self().getData(Ship.BANNER);
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1746) {
            class_1746 bannerItem = (class_1746)class_17922;
            poseStack.method_22903();
            Bannerable.BannerPosition pos = bannerShipEntity.getBannerPosition();
            poseStack.method_22907(class_1160.field_20705.method_23214(pos.yp));
            poseStack.method_22907(class_1160.field_20707.method_23214(pos.zp));
            poseStack.method_22904(pos.x, pos.y, pos.z);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            float bannerWaveAngle = bannerShipEntity.getBannerWaveAngle(partialTicks);
            if (!class_3532.method_15347((float)bannerWaveAngle, (float)0.0f)) {
                poseStack.method_22907(class_1160.field_20703.method_23214(bannerWaveAngle));
            }
            List patterns = class_2573.method_24280((class_1767)bannerItem.method_7706(), (class_2499)class_2573.method_24281((class_1799)item));
            class_823.method_29999((class_4587)poseStack, (class_4597)multiBufferSource, (int)packedLight, (int)class_4608.field_21444, (class_630)bannerModel, (class_4730)class_1088.field_20847, (boolean)true, (List)patterns);
            poseStack.method_22909();
        }
    }

    private void renderPaddle(Paddleable paddleShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
    }

    private void renderSail(Sailable sailShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        SailModel sailModel = sailModels.get(sailShipEntity.getClass());
        sailModel.method_2819((class_1297)((Ship)((Object)sailShipEntity)), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(sailModel.method_23500(SailModel.getSailColor((String)sailShipEntity.self().getData(Ship.SAIL_COLOR)).location));
        sailModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static String getNameFromType(class_1690.class_1692 type) {
        return type.method_7559().replace(":", "/");
    }

    static {
        class_630 model = class_823.method_32135().method_32109();
        model.method_32086((String)"pole").field_3665 = false;
        model.method_32086((String)"bar").field_3665 = false;
        bannerModel = model;
        sailModels = new HashMap<Class<? extends Ship>, SailModel>();
        sailModels.put(CogEntity.class, new CogSailModel());
        sailModels.put(BriggEntity.class, new BriggSailModel());
        sailModels.put(KhufuEntity.class, new CogSailModel());
    }
}

